/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model.code;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to multiple coupon codes
 */
@ToString
@EqualsAndHashCode
public class MultipleCouponCodeDto implements HasInitializedData, CouponCodeDto
{
	private transient List<String> initializedFields = ListUtils.newArrayList("type");

	private List<String> codes;
	private List<String> assignedCodes;


	/**
	 * The type of couponCode: multiple
	 * @return
	 */
	@Override
	public String getType() { return "multiple"; }


	/**
	 * The coupon codes to be used.
	 * @return
	 */
	public List<String> getCodes() { return codes; }
	public void setCodes( List<String> codes ) {
		initializedFields.add( "codes" );
		this.codes = codes;
	}


	/**
	 * The coupon codes that have been assigned to users
	 * @return
	 */
	public List<String> getAssignedCodes() { return assignedCodes; }
	public void setAssignedCodes( List<String> assignedCodes ) {
		this.assignedCodes = assignedCodes;
	}


	/**
	 * The list of initialised fields to send to the server
	 */
	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}



