/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import io.mambo.sdk.service.common.model.translation.AbstractTranslationDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the translations of a coupon
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class CouponTranslationDto extends AbstractTranslationDto
{
	private String name;
	private String custom;
	private String helpMessage;


	/**
	 * The name of the coupon.
	 * The field cannot be blank and cannot be longer than 300 characters.
	 */
	public String getName() { return name; }
	public void setName( String name )
	{
		initializedFields.add( "name" );
		this.name = name;
	}

	/**
	 * In the case of a custom based coupon, thus field should contain information
	 * relating to the nature of the coupon that is being given. For example: buy 1
	 * get 1 free.
	 * @return
	 */
	public String getCustomPrize() { return custom; }
	@JsonProperty( "custom" )
	public void setCustomPrize( String custom )
	{
		initializedFields.add( "custom" );
		this.custom = custom;
	}

	/**
	 * The message to be displayed in the coupon purchasing screen. This can provide
	 * more information about the coupon, how to redeem it, any exceptions for the
	 * coupon, etc.
	 * @return
	 */
	public String getHelpMessage() { return helpMessage; }
	public void setHelpMessage( String helpMessage )
	{
		initializedFields.add( "helpMessage" );
		this.helpMessage = helpMessage;
	}
}
