/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's coupons.
 * This class includes the list of coupons which can be bought
 * using points.
 */
@ToString
@EqualsAndHashCode
public class CouponStatesDto
{
	private List<CouponStateDto> unlocked;
	private List<CouponDto> buyable;


	/**
	 * The coupons which have been unlocked and awarded to the user.
	 * @return
	 */
	public List<CouponStateDto> getUnlocked() { return unlocked; }
	public void setUnlocked( List<CouponStateDto> unlocked ) { this.unlocked = unlocked; }

	/**
	 * The list of coupons which the user can buy with points.
	 * @return
	 */
	public List<CouponDto> getBuyable() { return buyable; }
	public void setBuyable( List<CouponDto> buyable ) { this.buyable = buyable; }
}
