/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a awarded coupon.
 */
@ToString
@EqualsAndHashCode
public class CouponStateDto
{
	private String id;
	private String userId;
	private String couponId;
	private List<CouponStateDetailsDto> stateDetails;
	private CouponDto coupon;


	/**
	 * The ID of the awarded coupon
	 * @return
	 */
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * The ID of the user to whom the coupon was awarded
	 * @return
	 */
	public String getUserId() { return userId; }
	public void setUserId( String userId ) { this.userId = userId; }

	/**
	 * The ID of the awarded coupon
	 * @return
	 */
	public String getCouponId() { return couponId; }
	public void setCouponId( String couponId ) { this.couponId = couponId; }

	/**
	 * Contains information about when the coupon was awarded to the user, whether
	 * it was exchanged for points and whether it has been redeemed (and when).
	 * @return
	 */
	public List<CouponStateDetailsDto> getStateDetails() { return stateDetails; }
	public void setStateDetails( List<CouponStateDetailsDto> stateDetails ) {
		this.stateDetails = stateDetails;
	}

	/**
	 * The coupon associated to the user.
	 * @return
	 */
	public CouponDto getCoupon() { return coupon; }
	public void setCoupon( CouponDto coupon ) { this.coupon = coupon; }
}
