/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model;

import java.util.List;

import io.mambo.sdk.service.common.model.PointStoreDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a coupon state.
 */
@ToString
@EqualsAndHashCode
public class CouponStateDetailsDto
{
	private String activityId;
	private String couponCode;
	private String awardedOn;
	private String expiryOn;
	private List<String> redeemedOn;
	private PointStoreDto pointsToBuy;


	/**
	 * The ID of the activity which awarded the coupon (if any)
	 * @return
	 */
	public String getActivityId() { return activityId; }
	public void setActivityId( String activityId ) { this.activityId = activityId; }

	/**
	 * The code of the coupon awarded to the user. This code is used to
	 * redeem or refund the coupon.
	 * @return
	 */
	public String getCouponCode() { return couponCode; }
	public void setCouponCode( String couponCode ) { this.couponCode = couponCode; }

	/**
	 * The date the coupon was awarded on as a string.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getAwardedOn() { return awardedOn; }
	public void setAwardedOn( String awardedOn ) { this.awardedOn = awardedOn; }

	/**
	 * The date on which the coupon state is going to expire
	 * or has expired on. This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ  For example:
	 * 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getExpiryOn() { return expiryOn; }
	public void setExpiryOn( String expiryOn ) { this.expiryOn = expiryOn; }

	/**
	 * The date the coupon was redeemed on as a list of strings.
	 * In the case of a multi-use coupon this would contain multiple dates.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public List<String> getRedeemedOn() { return redeemedOn; }
	public void setRedeemedOn( List<String> redeemedOn ) { this.redeemedOn = redeemedOn; }

	/**
	 * The number of points the coupon was exchanged for if
	 * the coupon can be bought with points.
	 * @return
	 */
	public PointStoreDto getPointsToBuy() { return pointsToBuy; }
	public void setPointsToBuy( PointStoreDto pointsToBuy ) { this.pointsToBuy = pointsToBuy; }
}
