/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.PointStoreDto;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to criteria to buy a Coupon with points.
 */
@ToString
@EqualsAndHashCode
public class BuyCriteriaDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private PointStoreDto pointsToBuy;
	private String buyRedemptionMode;


	/**
	 * The number of points required in order to buy this coupon.
	 * @return
	 */
	public PointStoreDto getPointsToBuy() { return pointsToBuy; }
	public void setPointsToBuy( PointStoreDto pointsToBuy ) {
		initializedFields.add( "pointsToBuy" );
		this.pointsToBuy = pointsToBuy;
	}

	/**
	 * The Buy Redemption Mode to use with this coupon.
	 * @return
	 */
	public String getBuyRedemptionMode() { return buyRedemptionMode; }
	public void setBuyRedemptionMode( String mode ) {
		initializedFields.add( "buyRedemptionMode" );
		this.buyRedemptionMode = mode;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}


