/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.data.RequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the Coupon API in
 * order to validate a coupon against the specified user.
 */
@ToString
@EqualsAndHashCode
public class CouponUserRequestData implements RequestData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String uuid;
	private String code;
	private String couponId;


	public static CouponUserRequestData fromCode( String uuid, String code )
	{
		CouponUserRequestData data = new CouponUserRequestData();
		data.setUuid( uuid );
		data.setCode( code );
		return data;
	}


	public static CouponUserRequestData fromCouponId( String uuid, String couponId )
	{
		CouponUserRequestData data = new CouponUserRequestData();
		data.setUuid( uuid );
		data.setCouponId( couponId );
		return data;
	}


	/**
	 * The Unique User ID of the user for whom we are validating the coupon code.
	 * This value cannot be empty.
	 * @return uuid
	 */
	public String getUuid() { return uuid; }
	public void setUuid( String uuid ) {
		initializedFields.add( "uuid" );
		this.uuid = uuid;
	}


	/**
	 * The coupon code to validate for the user.
	 * If the couponId is set, this field is ignored.
	 *
	 * @return code
	 */
	public String getCode() { return code; }
	public void setCode( String code ) {
		initializedFields.add( "code" );
		this.code = code;
	}


	/**
	 * The id of the coupon to validate for the user.
	 * If this field is set, the code field is ignored
	 * @return couponId
	 */
	public String getCouponId() { return couponId; }
	public void setCouponId( String couponId ) {
		initializedFields.add( "couponId" );
		this.couponId = couponId;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
