/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.param;

import static io.mambo.sdk.utils.Preconditions.checkNotNull;

import java.util.List;

import io.mambo.sdk.utils.Multimap;

public abstract class AbstractServiceParamsBuilder<P>
{
	protected Multimap<String, String> params = new Multimap<>();


	/**
	 * Add extra query parameters to the request. This method allows you
	 * to add new parameters before they are officially implemented in the
	 * SDK.
	 */
	@SuppressWarnings( "unchecked" )
	public P extraParams( String key, String value )
	{
		checkNotNull( key, "key must not be null" );
		checkNotNull( value, "value must not be null" );
		params.put( key, value );
		return (P) this;
	}


	/**
	 * Add extra query parameters to the request. This method allows you
	 * to add new parameters before they are officially implemented in the
	 * SDK.
	 */
	@SuppressWarnings( "unchecked" )
	public P extraParams( String key, List<String> values )
	{
		checkNotNull( key, "key must not be null" );
		checkNotNull( values, "values must not be null" );
		params.putAll( key, values );
		return (P) this;
	}
}
