/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.translation;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.common.model.interfaces.TranslationDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data shared between the different translation classes
 */
@ToString
@EqualsAndHashCode
public abstract class AbstractTranslationDto implements TranslationDto, HasInitializedData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String languageCode;

	/**
	 * The language code associated to this specific translation.
	 * See the language page in administration panel for more information.
	 */
	@Override
	public String getLanguageCode() { return languageCode; }
	public void setLanguageCode( String languageCode ) { initializedFields.add( "languageCode" ); this.languageCode = languageCode; }

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
