/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.tag;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Implements the {@link HasTagsRequestData} interface
 */
@ToString
@EqualsAndHashCode
public abstract class AbstractHasAwardByTagRequestData implements HasAwardByTagRequestData, HasInitializedData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private Boolean awardOnlyIfPersonalizationTagsMatch;

	/**
	 * Indicates that this behaviour should be awarded to a user only if one of the
	 * following criteria is matched:
	 * 1) User and Behaviour have at least one personalization tag that matches
	 * 2) Behaviour has no personalization tags
	 * @return
	 */
	@Override
	public Boolean getAwardOnlyIfPersonalizationTagsMatch() { return awardOnlyIfPersonalizationTagsMatch; }
	@Override
	public void setAwardOnlyIfPersonalizationTagsMatch( Boolean awardOnlyIfPersonalizationTagsMatch ) {
		initializedFields.add( "awardOnlyIfPersonalizationTagsMatch" );
		this.awardOnlyIfPersonalizationTagsMatch = awardOnlyIfPersonalizationTagsMatch;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
