/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.summary;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Interface implemented by all the Summary DTOs
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "type" )
@JsonSubTypes({
    @Type(value = ActivitySummaryDto.class, name = "activity"),
    @Type(value = PointSummaryDto.class, name = "point"),
    @Type(value = BehaviourSummaryDto.class, name = "behaviour"),
    @Type(value = RewardSummaryDto.class, name = "reward"),
    @Type(value = KPISummaryDto.class, name = "kpi"),
    @Type(value = CouponSummaryDto.class, name = "coupon") })
public interface SummaryDto
{
	/**
	 * Get the type of summary object
	 * @return
	 */
	String getType();
}
