/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.summary;

import io.mambo.sdk.service.common.model.ImageDto;
import io.mambo.sdk.service.point.model.UnitsDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Summary information of the point so that it can be displayed.
 */
@ToString
@EqualsAndHashCode
public class PointSummaryDto implements SummaryDto
{
	private String name;
	private String description;
	private UnitsDto units;
	private boolean hideInSummary;
	private ImageDto image;


	/**
	 * The type of summary
	 * @return
	 */
	@Override
	public String getType() { return "point"; }


	/**
	 * The name of the point.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }

	/**
	 * The description associated with the point.
	 * @return
	 */
	public String getDescription() { return description; }
	public void setDescription( String description ) { this.description = description; }

	/**
	 * This contains the point's units of measure.
	 * See the {@link UnitsDto} object for more information.
	 * @return
	 */
	public UnitsDto getUnits() { return units; }
	public void setUnits( UnitsDto units ) { this.units = units; }

	/**
	 * Indicates whether the point should be hidden in the summary
	 * of the Profile and Header widgets. This is usually associated
	 * to KPIs or points which are used only for tracking.
	 * @return
	 */
	public Boolean getHideInSummary() { return hideInSummary; }
	public void setHideInSummary( boolean hideInSummary ) { this.hideInSummary = hideInSummary; }

	/**
	 * The point's image.
	 * See the {@link ImageDto} object for more information.
	 * @return
	 */
	public ImageDto getImage() { return image; }
	public void setImage( ImageDto image ) { this.image = image; }
}
