/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.summary;

import io.mambo.sdk.service.common.model.ImageDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Summary information of the KPI so that it can be displayed.
 */
@ToString
@EqualsAndHashCode
public class KPISummaryDto implements SummaryDto
{
	private String name;
	private String description;
	private ImageDto image;


	/**
	 * The type of summary
	 * @return
	 */
	@Override
	public String getType() { return "kpi"; }


	/**
	 * The name of the KPI.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }

	/**
	 * The description associated with the KPI.
	 * @return
	 */
	public String getDescription() { return description; }
	public void setDescription( String description ) { this.description = description; }

	/**
	 * The KPI's image.
	 * See the {@link ImageDto} object for more information.
	 * @return
	 */
	public ImageDto getImage() { return image; }
	public void setImage( ImageDto image ) { this.image = image; }
}
