/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.summary;

import io.mambo.sdk.service.common.model.ImageDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Summary information of the behaviour so that it can be displayed.
 */
@ToString
@EqualsAndHashCode
public class BehaviourSummaryDto implements SummaryDto
{
	private String name;
	private String message;
	private ImageDto image;


	/**
	 * The type of summary
	 * @return
	 */
	@Override
	public String getType() { return "behaviour"; }


	/**
	 * The name of the behaviour.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }

	/**
	 * The message associated with the behaviour.
	 * @return
	 */
	public String getMessage() { return message; }
	public void setMessage( String message ) { this.message = message; }

	/**
	 * The behaviour's image.
	 * See the {@link ImageDto} object for more information.
	 * @return
	 */
	public ImageDto getImage() { return image; }
	public void setImage( ImageDto image ) { this.image = image; }
}
