/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.response;

import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.exception.MamboExceptionFactory;
import io.mambo.sdk.http.HttpStatus;
import io.mambo.sdk.utils.StringUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@ToString
@EqualsAndHashCode
public class RejectActivityResponse
{
	private static MamboExceptionFactory exceptionFactory = new MamboExceptionFactory();

	private String activityId;
	private Status status;
	private MamboApiException exception;


	/**
	 * The ID of the activity that was rejected.
	 * @return
	 */
	public String getActivityId() { return activityId; }
	public void setActivityId( String activityId ) { this.activityId = activityId; }

	/**
	 * The status of the reject. Options include OK when the reject is
	 * successful or the name of the Exception when there is a problem.
	 * @return
	 */
	public Status getStatus() { return status; }
	public void setStatus( Status status ) { this.status = status; }

	/**
	 * The exception which caused the reject to fail. This will only be populated if the reject fails.
	 * @return
	 */
	public MamboApiException getError() { return exception; }
	public void setError( String error ) {
		if( StringUtils.isNotEmpty( error ) ) {
			exception = exceptionFactory.createMamboApiException( error, HttpStatus.BAD_REQUEST );
		}
	}
}
