/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.response;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

@ToString
@EqualsAndHashCode
public class RejectActivityBulkResponse
{
	private Long numOfRejected;
	private Long numOfFailed;
	private List<RejectActivityResponse> rejected;


	/**
	 * The number of activities that were successfully rejected.
	 * @return
	 */
	public Long getNumOfRejected() { return numOfRejected; }
	public void setNumOfRejected( Long numOfRejected ) { this.numOfRejected = numOfRejected; }

	/**
	 * The number of activities that failed to be rejected.
	 * @return
	 */
	public Long getNumOfFailed() { return numOfFailed; }
	public void setNumOfFailed( Long numOfFailed ) { this.numOfFailed = numOfFailed; }

	/**
	 * The list of individual activities rejected and the outcome of each operation.
	 * @return
	 */
	public List<RejectActivityResponse> getRejected() { return rejected; }
	public void setRejected( List<RejectActivityResponse> rejected ) { this.rejected = rejected; }
}
