/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence.period.criteria;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on specific week numbers of the year and days.
 * For example:
 * - On the 23rd and 45th week on the Monday and Friday
 */
@ToString
@EqualsAndHashCode
public class FixedPeriodCriteriaWeeksOfYearDto implements FixedPeriodCriteriaDto
{
	private List<Integer> weeksOfYear;
	private List<Integer> daysOfWeek;


	/**
	 * The weeks of year indicate on which weeks of the year the object should recur.
	 * Valid values range from 1 to 53.
	 * This field cannot be null.
	 */
	public List<Integer> getWeeksOfYear() { return weeksOfYear; }
	public void setWeeksOfYear( List<Integer> weeksOfYear ) { this.weeksOfYear = weeksOfYear; }


	/**
	 * The days indicates the days of the week on which the object should recur.
	 * Valid values range from 0 to 6 where 0 indicates Monday and 6 indicates Sunday.
	 * This field cannot be null.
	 */
	public List<Integer> getDaysOfWeek() { return daysOfWeek; }
	public void setDaysOfWeek( List<Integer> daysOfWeek ) { this.daysOfWeek = daysOfWeek; }


	/**
	 * The type of fixed period criteria: weeksOfYear
	 * @return
	 */
	@Override
	public String getType() { return "weeksOfYear"; }
}
