/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence.period.criteria;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on specific weeks of a month and days.
 * For example:
 * - On the 1st and 2nd week on the Monday and Friday
 */
@ToString
@EqualsAndHashCode
public class FixedPeriodCriteriaWeeksOfMonthDto implements FixedPeriodCriteriaDto
{
	private List<Integer> weeksOfMonth;
	private List<Integer> daysOfWeek;


	/**
	 * The weeks of month indicate on which weeks of the month the object should recur.
	 * Valid values range from 1 to 5 where 1 is the 1st week and 5 is "the last week" of the month.
	 * This field cannot be null.
	 */
	public List<Integer> getWeeksOfMonth() { return weeksOfMonth; }
	public void setWeeksOfMonth( List<Integer> weeksOfMonth ) { this.weeksOfMonth = weeksOfMonth; }


	/**
	 * The days indicates the days of the week on which the object should recur.
	 * Valid values range from 0 to 6 where 0 indicates Monday and 6 indicates Sunday.
	 * This field cannot be null.
	 */
	public List<Integer> getDaysOfWeek() { return daysOfWeek; }
	public void setDaysOfWeek( List<Integer> daysOfWeek ) { this.daysOfWeek = daysOfWeek; }


	/**
	 * The type of fixed period criteria: weeksOfMonth
	 * @return
	 */
	@Override
	public String getType() { return "weeksOfMonth"; }
}
