/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence.period;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * The {@link VariablePeriodDto} is used in order to define the
 * period of time after which an objects recurrence needs
 * to be processed.
 */
@ToString
@EqualsAndHashCode
public class VariablePeriodDto
{
	private String type;
	private Integer value;


	/**
	 * The type indicates the period's units of measure.
	 * Valid types include: hours, days, weeks, months and years.
	 * This field cannot be null.
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getType() { return type; }
	public void setType( String type ) { this.type = type; }

	/**
	 * The value is the number of units of measure after which
	 * the recurrence should take place. For example: if the type
	 * is months and the value is 12, then the recurrence will take
	 * place after 12 months.
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public Integer getValue() { return value; }
	public void setValue( Integer value ) { this.value = value; }
}
