/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence.period;

import java.util.List;

import io.mambo.sdk.service.common.model.recurrence.period.criteria.FixedPeriodCriteriaDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on a fixed yearly interval.
 * For example:
 * - Yearly in January on the 20th at 13:00PM
 */
@ToString
@EqualsAndHashCode
public class FixedPeriodYearlyDto implements FixedPeriodDto
{
	private Integer hour;
	private List<Integer> months;
	private Integer yearInterval;
	private String periodStart;
	private FixedPeriodCriteriaDto criteria;



	/**
	 * The criteria field indicates on what criteria we should base the recurrence.
	 * This field cannot be null.
	 */
	public FixedPeriodCriteriaDto getCriteria() { return criteria; }
	public void setCriteria( FixedPeriodCriteriaDto criteria ) { this.criteria = criteria; }


	/**
	 * The months indicates the months of the year on which the object should recur. Note that
	 * if you use the WeeksOfYear criteria then these months will be ignored and the weeks will
	 * take precedence over the months.
	 * Valid values range from 1 to 12 where 1 indicates January and 12 indicates December.
	 * This field cannot be null.
	 */
	public List<Integer> getMonths() { return months; }
	public void setMonths( List<Integer> months ) { this.months = months; }


	/**
	 * The hour indicates the hour on which the object should recur.
	 * Valid values range from 0 to 23 where 0 indicates midnight.
	 * This field cannot be null.
	 */
	public Integer getHour() { return hour; }
	public void setHour( Integer hour ) { this.hour = hour; }


	/**
	 * The year interval indicates every how many years the object should recur.
	 * Valid values range from 1 to 10.
	 * This field cannot be null.
	 */
	public Integer getYearInterval() { return yearInterval; }
	public void setYearInterval( Integer yearInterval ) { this.yearInterval = yearInterval; }


	/**
	 * The period start date indicates the date from which the interval should start.
	 * Note that only the date portion of the time stamp will be used.
	 * This will be a UTC time stamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ<br>
	 * For example: 2013-01-20T20:43:24.094Z
	 * This field cannot be null.
	 */
	public String getPeriodStart() { return periodStart; }
	public void setPeriodStart( String periodStart ) { this.periodStart = periodStart; }


	/**
	 * The type of expiration: yearly
	 * @return
	 */
	@Override
	public String getType() { return "yearly"; }
}
