/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence.period;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on a fixed hourly interval.
 * For example:
 * - Hourly
 */
@ToString
@EqualsAndHashCode
public class FixedPeriodHourlyDto implements FixedPeriodDto
{
	private Integer hour;
	private Integer hourInterval;
	private String periodStart;


	/**
	 * The hour indicates the hour on which the object should recur.
	 * Valid values range from 0 to 23 where 0 indicates midnight.
	 * This field cannot be null.
	 */
	public Integer getHour() { return hour; }
	public void setHour( Integer hour ) { this.hour = hour; }


	/**
	 * The hour interval indicates every how many hours the object should recur.
	 * Valid values range from 1 to 24.
	 * This field cannot be null.
	 */
	public Integer getHourInterval() { return hourInterval; }
	public void setHourInterval( Integer hourInterval ) { this.hourInterval = hourInterval; }


	/**
	 * The period start date indicates the date from which the interval should start.
	 * Note that only the date portion of the time stamp will be used.
	 * This will be a UTC time stamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ<br>
	 * For example: 2013-01-20T20:43:24.094Z
	 * This field cannot be null.
	 */
	public String getPeriodStart() { return periodStart; }
	public void setPeriodStart( String periodStart ) { this.periodStart = periodStart; }


	/**
	 * The type of fixed period: hourly
	 * @return
	 */
	@Override
	public String getType() { return "hourly"; }
}
