/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence;

import io.mambo.sdk.service.common.model.recurrence.period.VariablePeriodDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on a variable time interval
 * which begins from the date the object was created.
 * For example:
 * - 2 hours after creation
 * - 3 days after creation
 * - 4 weeks after creation
 * - 5 months after creation
 * - 6 years after creation
 */
@ToString
@EqualsAndHashCode
public class VariablePeriodRecurrenceDto implements RecurrenceDto
{
	private VariablePeriodDto period;


	/**
	 * The type of recurrence: variable_period
	 * This field cannot be null.
	 * @return
	 */
	@Override
	public String getType() { return "variable_period"; }


	/**
	 * Defines a period of time after which an object should recur.
	 * See the {@link VariablePeriodDto} object for more information.
	 * @return
	 */
	public VariablePeriodDto getPeriod() { return period; }
	public void setPeriod( VariablePeriodDto period ) { this.period = period; }
}
