/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Defines recurrences
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "type" )
@JsonSubTypes({
    @Type(value = VariablePeriodRecurrenceDto.class, name = "variable_period"),
    @Type(value = FixedPeriodRecurrenceDto.class, name = "fixed_period"),
    @Type(value = FixedDateRecurrenceDto.class, name = "fixed_date"),
    @Type(value = NeverRecurrenceDto.class, name = "never") })
public interface RecurrenceDto
{
	/**
	 * Returns the type of recurrence.
	 * @return
	 */
	String getType();
}
