/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.recurrence;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Represents an object which recurs on a fixed date.
 * For example: 24/01/2015
 */
@ToString
@EqualsAndHashCode
public class FixedDateRecurrenceDto implements RecurrenceDto
{
	private String date;


	/**
	 * The type of recurrence: fixed_date
	 * This field cannot be null.
	 * @return
	 */
	@Override
	public String getType() { return "fixed_date"; }


	/**
	 * This field contains the exact recurrence date of the object.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ<br>
	 * For example: 2013-01-20T20:43:24.094Z
	 * This field cannot be null.
	 * @return
	 */
	public String getDate() { return date; }
	public void setDate( String date ) { this.date = date; }
}
