/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.awarded;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Interface implemented by all the Awarded DTOs
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "awardedType" )
@JsonSubTypes({
	@Type(value = AwardedBehaviourDto.class, name = "behaviour"),
    @Type(value = AwardedRewardDto.class, name = "reward"),
    @Type(value = AwardedActivityDto.class, name = "activity"),
    @Type(value = AwardedCouponDto.class, name = "coupon"),
    @Type(value = AwardedKpiDto.class, name = "kpi") })
public interface AwardedDto
{
	/**
	 * Get the type of awarded object
	 * @return
	 */
	String getAwardedType();
	
	/**
	 * Test if the awarded object ID matches the supplied ID
	 */
	Boolean matchesId( String otherId );
	
	/**
	 * The date on which the item was awarded to a user.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 * @deprecated For removal
	 */
	@Deprecated
	String getAwardedOn();
}
