/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model.awarded;

import com.fasterxml.jackson.annotation.JsonIgnore;

import io.mambo.sdk.service.coupon.model.CouponDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to an object's coupons.
 */
@ToString
@EqualsAndHashCode
public class AwardedCouponDto implements AwardedDto
{
	private String parentId;
	private String couponStateId;
	private String couponId;
	private boolean rejected;
	private CouponDto coupon;



	@Override
	public String getAwardedType()
	{
		return "coupon";
	}


	/**
	 * @see AwardedDto#matchesId(String)
	 */
	@Override
	@JsonIgnore
	public Boolean matchesId( String otherId )
	{
		return couponId.equals( otherId );
	}


	/**
	 * The ID of the parent mechanic that awarded the coupon to the user
	 * @return
	 */
	public String getParentId() { return parentId; }
	public void setParentId( String parentId ) {
		this.parentId = parentId;
	}

	/**
	 * The ID of the coupon state associated with this object.
	 * This field cannot be null.
	 * @return
	 */
	public String getCouponStateId() { return couponStateId; }
	public void setCouponStateId( String couponStateId ) {
		this.couponStateId = couponStateId;
	}

	/**
	 * The ID of the coupon awarded to the user.
	 * @return
	 */
	public String getCouponId() { return couponId; }
	public void setCouponId( String couponId ) {
		this.couponId = couponId;
	}

	/**
	 * True if the coupon is rejected.
	 * @return
	 */
	public boolean getRejected() { return rejected; }
	public void setRejected( boolean rejected ) {
		this.rejected = rejected;
	}

	/**
	 * The coupon that was awarded. This will only be
	 * available when retrieving notifications.
	 * @return
	 */
	public CouponDto getCoupon() { return coupon; }
	public void setCoupon( CouponDto coupon ) {
		this.coupon = coupon;
	}


	@Override
	public String getAwardedOn()
	{
		throw new UnsupportedOperationException( "This method is not supported for AwardedCouponDto" );
	}
}
