/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates summary data related to a user
 */
@ToString
@EqualsAndHashCode
public class UserSummaryDto
{
	private String userId;
	private String firstName;
	private String lastName;
	private String displayName;


	/**
	 * Gets the users ID
	 * @return
	 */
	public String getUserId() { return userId; }
	public void setUserId( String userId ) { this.userId= userId ; }

	/**
	 * The name to be displayed when a user's information is being displayed.
	 */
	public String getDisplayName() { return displayName; }
	public void setDisplayName( String displayName ) { this.displayName= displayName ; }

	/**
	 * The user's first name.
	 */
	public String getFirstName() { return firstName; }
	public void setFirstName( String firstName ) { this.firstName= firstName ; }

	/**
	 * The user's last name.
	 */
	public String getLastName() { return lastName; }
	public void setLastName( String lastName ) { this.lastName= lastName ; }
}
