/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to an item's scarcity.
 * Scarcity allows you to specify the overall number of times that
 * a particular item can be unlocked. This effectively creates a
 * limited series item which can only be unlocked X times.
 */
@ToString
@EqualsAndHashCode
public class ScarcityDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Integer limit;
	private Integer counter;


	/**
	 * The limit represents the overall number of times that a particular
	 * item can be unlocked.
	 * @return
	 */
	public Integer getLimit() { return limit; }
	public void setLimit( Integer limit ) {
		initializedFields.add( "limit" );
		this.limit = limit;
	}

	/**
	 * The counter represents the overall number of times that a particular
	 * item has been unlocked. This is only used when a Reward is returned
	 * from the platform.
	 * @return
	 */
	public Integer getCounter() { return counter; }
	public void setCounter( Integer counter ) {
		initializedFields.add( "counter" );
		this.counter = counter;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
