/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a image.
 */
@ToString
@EqualsAndHashCode
public class ImageDto
{
	private Long lastUpdatedOn;
	private String mimeType;
	private String url;


	/**
	 * The timestamp of the last update of the image.
	 * @return
	 */
	public Long getLastUpdatedOn(){ return lastUpdatedOn; }
	public void setLastUpdatedOn( Long lastUpdateOn ){ lastUpdatedOn = lastUpdateOn; }


	/**
	 * The MimeType of the image used.
	 * @return
	 */
	public String getMimeType(){ return mimeType; }
	public void setMimeType( String mimeType ){ this.mimeType = mimeType; }


	/**
	 * The image URL. This is a link to the image associated
	 * with this parent object.
	 * @return
	 */
	public String getUrl(){ return url; }
	public void setUrl( String url ){ this.url = url; }
}
