/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a custom field settings.
 */
@ToString
@EqualsAndHashCode
public class CustomFieldValueDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String name;
	private String value;
	private ImageDto image = new ImageDto();


	public CustomFieldValueDto(){}


	public CustomFieldValueDto( String name, String value )
	{
		this.name = name;
		this.value = value;
	}


	/**
	 * The name of the custom field.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) {
		initializedFields.add( "name" );
		this.name = name;
	}

	/**
	 * The value of the custom field.
	 * @return
	 */
	public String getValue() { return value; }
	public void setValue( String value ) {
		initializedFields.add( "value" );
		this.value = value;
	}

	/**
	 * The CustonFieldValue's image. This is an object with the data.
	 * @return
	 */
	public ImageDto getImage() { return image; }
	public void setImage( ImageDto image ) { this.image = image; }

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
