/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.data;

import static io.mambo.sdk.utils.Preconditions.checkNotNull;

import java.io.File;
import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by any of the APIs
 * which allow an file to be uploaded
 */
@ToString
@EqualsAndHashCode
public class FileRequestData implements RequestData
{
	private final File file;
	private final Object data;


	public FileRequestData( File file )
	{
		this( file, null );
	}


	public FileRequestData( File file, Object data )
	{
		checkNotNull( file, "file must not be null" );
		this.file = file;
		this.data = data;
	}


	public File getFile()
	{
		return file;
	}


	public boolean hasData()
	{
		return data != null;
	}


	public Object getData()
	{
		return data;
	}


	@Override
	public List<String> getInitializedFields() {
		return ListUtils.newArrayList();
	}
}