/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the APIs in
 * order to delete a list of objects.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class DeleteRequestData extends AbstractIdListRequestData
{
	public DeleteRequestData( List<String> ids ) {
		super( ids );
	}


	/**
	 * Build the {@link DeleteRequestData} using the IDs of the objects
	 */
	public static DeleteRequestData from( List<? extends AggregateDto> aggregates )
	{
		List<String> ids = new ArrayList<>();
		for( AggregateDto aggregate : aggregates ) {
			ids.add( aggregate.getId() );
		}
		return new DeleteRequestData( ids );
	}
}