/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the User / Behaviour
 * and Reward APIs when modifying custom fields
 */
@ToString
@EqualsAndHashCode
public class CustomFieldValueRequestData implements RequestData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private List<CustomFieldValueDto> customFields;

	public CustomFieldValueRequestData( CustomFieldValueDto...customFields ) {
		this.customFields = ListUtils.of( customFields );
	}


	/**
	 * Custom fields defined for the user, behaviour or reward. These can contain
	 * additional data or any kind of information you would like to store which
	 * isn't a standard field of the object.
	 */
	public List<CustomFieldValueDto> getCustomFields() { return customFields; }
	public void setCustomFields( List<CustomFieldValueDto> customFields ) {
		initializedFields.add( "customFields" );
		this.customFields = customFields;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}