/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.common.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the APIs in
 * order to deal with a list of objects.
 */
@ToString
@EqualsAndHashCode
public class AbstractIdListRequestData implements RequestData
{
	private List<String> ids = new ArrayList<>();

	public AbstractIdListRequestData() {}

	public AbstractIdListRequestData( List<String> ids )
	{
		this.ids = ids;
	}

	/**
	 * The list of Aggregate IDs
	 * @return ids
	 */
	public List<String> getIds() { return ids; }
	public void setIds( List<String> ids ) { this.ids = ids; }
	public void addId( String id ) { ids.add( id ); }


	@Override
	public List<String> getInitializedFields() {
		return ListUtils.newArrayList( "ids" );
	}
}
