/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model.metadata;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Contains a list of metadata conditions joined by a logical OR operator.
 */
@ToString
@EqualsAndHashCode
public class OrMetadataConditionDto implements MetadataConditionDto
{
	private List<MetadataConditionDto> conditions;

	public OrMetadataConditionDto() {}

	public OrMetadataConditionDto( List<MetadataConditionDto> conditions ) {
		this.conditions = conditions;
	}

	/**
	 * The type of condition: or
	 * @return
	 */
	@Override
	public String getType() { return "or"; }

	/**
     * Contains all the conditions which need to be joined together with
     * an "or" logical operator.
	 * @return
	 */
	public List<MetadataConditionDto> getConditions() { return conditions; }
	public void setConditions( List<MetadataConditionDto> conditions ) {
		this.conditions = conditions;
	}

	public void addCondition( MetadataConditionDto condition ) {
		if( ListUtils.isEmpty( conditions ) ) {
			conditions = new ArrayList<>();
		}
		conditions.add( condition );
	}
}
