/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model.metadata;

import io.mambo.sdk.utils.StringUtils;

public enum MetadataOperator
{
	GREATER_THAN("$gt"),
	GREATER_THAN_OR_EQUAL_TO("$gte"),
	LESS_THAN("$lt"),
	LESS_THAN_OR_EQUAL_TO("$lte"),
	ON("$on"),
	NOT_ON("$non"),
	AFTER("$after"),
	ON_OR_AFTER("$onafter"),
	BEFORE("$before"),
	ON_OR_BEFORE("$onbefore"),
	EQUAL_TO("$eq"),
	NOT_EQUAL_TO("$neq"),
	CONTAINS("$in"),
	NOT_CONTAINS("$nin"),
	STARTS_WITH("$sw"),
	NOT_STARTS_WITH("$nsw"),
	ENDS_WITH("$ew"),
	NOT_ENDS_WITH("$new");

	private String type;
	private MetadataOperator( String type ) { this.type = type;}
	public String value() { return this.type; }

	public Boolean isGreaterThan() { return this == GREATER_THAN; }
	public Boolean isGreaterThanOrEqualTo() { return this == GREATER_THAN_OR_EQUAL_TO; }
	public Boolean isLessThan() { return this == LESS_THAN; }
	public Boolean isLessThanOrEqualTo() { return this == LESS_THAN_OR_EQUAL_TO; }
	public Boolean isOn() { return this == ON; }
	public Boolean isNotOn() { return this == NOT_ON; }
	public Boolean isAfter() { return this == AFTER; }
	public Boolean isOnOrAfter() { return this == ON_OR_AFTER; }
	public Boolean isBefore() { return this == BEFORE; }
	public Boolean isOnOrBefore() { return this == ON_OR_BEFORE; }
	public Boolean isEqualTo() { return this == EQUAL_TO; }
	public Boolean isNotEqualTo() { return this == NOT_EQUAL_TO; }
	public Boolean isContains() { return this == CONTAINS; }
	public Boolean isNotContains() { return this == NOT_CONTAINS; }
	public Boolean isStartsWith() { return this == STARTS_WITH; }
	public Boolean isNotStartsWith() { return this == NOT_STARTS_WITH; }
	public Boolean isEndsWith() { return this == ENDS_WITH; }
	public Boolean isNotEndsWith() { return this == NOT_ENDS_WITH; }

	public Boolean isNumeric() {
		return isGreaterThan() || isGreaterThanOrEqualTo() || isLessThan() || isLessThanOrEqualTo();
	}

	public Boolean isDate() {
		return isOn() || isNotOn() || isAfter() || isOnOrAfter() || isBefore() || isOnOrBefore();
	}

	public static MetadataOperator fromString( String type )
	{
		if( StringUtils.isEmpty( type ) ) {
			throw new IllegalArgumentException( "MetadataOperator type cannot be empty" );
		}

		for( MetadataOperator ps : MetadataOperator.values() )
		{
			if( type.equalsIgnoreCase( ps.type ) )
			{
				return ps;
			}
		}
		return null;
	}
}