/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model.metadata;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This contains Metadata key / value pairs
 */
@ToString
@EqualsAndHashCode
public class MetadataDto
{
	private String name;
	private String value;


	/**
	 * Constructor
	 */
	public MetadataDto() {}


	/**
	 * Constructor
	 *
	 * @param name	The name of the metadata
	 * @param value	The value of the metadata
	 */
	public MetadataDto( String name, String value )
	{
		this.name = name;
		this.value = value;
	}


	/**
	 * The name of the metadata
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }


	/**
	 * The value of the metadata
	 * @return
	 */
	public String getValue() { return value; }
	public void setValue( String value ) { this.value = value; }
}
