/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model.attributes;

import java.util.List;

import io.mambo.sdk.service.behaviour.model.metadata.MetadataConditionDto;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines behaviours attributes specific to Flexible Behaviours.
 */
@ToString
@EqualsAndHashCode
public class FlexibleAttrs implements BehaviourAttrs
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String behaviourId;
	private MetadataConditionDto metadata;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return "flexible"; }

	/**
	 * The ID of the underlying simple behaviour
	 * @return
	 */
	public String getBehaviourId() { return behaviourId; }
	public void setBehaviourId( String behaviourId ) {
		initializedFields.add( "behaviourId" );
		this.behaviourId = behaviourId;
	}

	/**
     * This contains a list of all the meta data conditions
     * associated with the Flexible Behaviour.
	 * See the flexible behaviour page in th administration panel for more information.
	 * @return
	 */
	public MetadataConditionDto getMetadata() { return metadata; }
	public void setMetadata( MetadataConditionDto metadata ) {
		initializedFields.add( "metadata" );
		this.metadata = metadata;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
