/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model.attributes;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;

import com.fasterxml.jackson.annotation.JsonTypeInfo;


/**
 * Defines behaviour attributes
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "type" )
@JsonSubTypes({
	@Type(value = SimpleAttrs.class, name = "simple"),
    @Type(value = FlexibleAttrs.class, name = "flexible") })
public interface BehaviourAttrs extends HasInitializedData
{
	/**
	 * Returns the type of attribute.
	 * @return
	 */
	String getType();
}
