/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.common.model.interfaces.HasRecurrence;
import io.mambo.sdk.service.common.model.recurrence.RecurrenceDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a behaviour's rate / count limits
 * applied to the repetitions of this behaviour.
 */
@ToString
@EqualsAndHashCode
public class LimitDto implements HasRecurrence, HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String scope;
	private Long count;
	private RecurrenceDto expiration;


	/**
	 * Get the count which determines the number of repetitions of this behaviour per user
	 * @return
	 */
	public Long getCount() { return count; }
	public void setCount( Long count ) {
		initializedFields.add( "count" );
		this.count = count;
	}

	/**
	 * Get the scope which is used to apply the count limit to a specific metadata's values.
	 * For example, you could limit the behaviour to one repetition per blog_id or per product_sku.
	 * Note: the count scope is only applied on Flexible Behaviours.
	 * @return
	 */
	public String getScope() { return scope; }
	public void setScope( String scope ) {
		initializedFields.add( "scope" );
		this.scope = scope;
	}

	/**
	 * This determines how often the count is reset. This could be never (i.e. a finite repetition per user),
	 * or it could be a recurring period of fixed time (i.e. reset the count every 12 hours, or every 2 days).
	 * Limit supports the following types of resets: never and fixed_period
	 */
	@Override
	public RecurrenceDto getExpiration() { return expiration; }
	@Override
	public void setExpiration( RecurrenceDto expiration ) {
		initializedFields.add( "expiration" );
		this.expiration = expiration;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
