/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.behaviour.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a behaviour's activity stream text
 */
@ToString
@EqualsAndHashCode
public class ActivityStreamDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String contentPrefix;
	private String targetPrefix;


	/**
	 * The text that prefixes the content object in the activity stream.
	 * The activity stream has the following format:
	 * User [contentPrefix] content-object [targetPrefix] target-object
	 * For example: John Doe [has posted] an article [to their] wall
	 * See the behaviours page in administration panel for more information.
	 * @return
	 */
	public String getContentPrefix() { return contentPrefix; }
	public void setContentPrefix( String contentPrefix ) {
		initializedFields.add( "contentPrefix" );
		this.contentPrefix = contentPrefix;
	}

	/**
	 * The text that prefixes the target object in the activity stream.
	 * The activity stream has the following format:
	 * User [contentPrefix] content-object [targetPrefix] target-object
	 * For example: John Doe [has posted] an article [to their] wall
	 * See the behaviours page in administration panel for more information.
	 * @return
	 */
	public String getTargetPrefix() { return targetPrefix; }
	public void setTargetPrefix( String targetPrefix ) {
		initializedFields.add( "targetPrefix" );
		this.targetPrefix = targetPrefix;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
