/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics.model.attributes.datapoint;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;

/**
 * Defines analytics attributes specific to a user data point
 */
public class UserDataPoint implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Long total;
	private Long created;
	private Long deleted;
	private Long totalMembers;
	private Long memberJoined;
	private Long memberLeft;


	/**
	 * The total number of users total
	 * @return
	 */
	public Long getTotal() { return total; }
	public void setTotal( Long total ) {
		initializedFields.add( "total" );
		this.total = total;
	}

	/**
	 * The total number of users created
	 * @return
	 */
	public Long getCreated() { return created; }
	public void setCreated( Long created ) {
		initializedFields.add( "created" );
		this.created = created;
	}

	/**
	 * The total number of users deleted
	 * @return
	 */
	public Long getDeleted() { return deleted; }
	public void setDeleted( Long deleted ) {
		initializedFields.add( "deleted" );
		this.deleted = deleted;
	}

	/**
	 * The total number of users who are members
	 * @return
	 */
	public Long getTotalMembers() { return totalMembers; }
	public void setTotalMembers( Long totalMembers ) {
		initializedFields.add( "totalMembers" );
		this.totalMembers = totalMembers;
	}

	/**
	 * The total number of users who became members
	 * @return
	 */
	public Long getMemberJoined() { return memberJoined; }
	public void setMemberJoined( Long memberJoined )
	{
		initializedFields.add( "memberJoined" );
		this.memberJoined = memberJoined;
	}

	/**
	 * The total number of users who left membership
	 * @return
	 */
	public Long getMemberLeft() { return memberLeft; }
	public void setMemberLeft( Long memberLeft ) {
		initializedFields.add( "memberLeft" );
		this.memberLeft = memberLeft;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}

	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		builder.append( "UserDataPoint [total=" );
		builder.append( total );
		builder.append( ", created=" );
		builder.append( created );
		builder.append( ", deleted=" );
		builder.append( deleted );
		builder.append( ", totalMembers=" );
		builder.append( totalMembers );
		builder.append( ", memberJoined=" );
		builder.append( memberJoined );
		builder.append( ", memberLeft=" );
		builder.append( memberLeft );
		builder.append( "][super: " );
		builder.append( super.toString() );
		builder.append( "]" );
		return builder.toString();
	}
}
