/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics.model.attributes.datapoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;

/**
 * Defines analytics attributes specific to an ID list data point
 */
public class IdListDataPoint implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Long total;
	private Map<String, Long> totalById;


	/**
	 * The total number of activities counted
	 * @return
	 */
	public Long getTotal() { return total; }
	public void setTotal( Long total )
	{
		initializedFields.add( "total" );
		this.total = total;
	}

	/**
	 * The total number of behaviours or rewards earned by ID
	 * @return
	 */
	public Map<String,Long> getTotalById() { return totalById; }
	public void setTotalById( Map<String, Long> totalById )
	{
		initializedFields.add( "totalById" );
		this.totalById = totalById;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}

	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		builder.append( "IdListDataPoint [total=" );
		builder.append( total );
		builder.append( ", totalById=" );
		builder.append( totalById );
		builder.append( "][super: " );
		builder.append( super.toString() );
		builder.append( "]" );
		return builder.toString();
	}
}
