/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics.model.attributes.datapoint;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;

/**
 * Defines analytics attributes specific to an activity data point
 */
public class ActivityDataPoint implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Long total;
	private Long gifts;
	private Long behaviours;
	private Long bountiesStarted;
	private Long bountiesAwarded;
	private Long bountiesCancelled;
	private Long pointIncrement;
	private Long pointSet;
	private Long pointRedeem;
	private Long pointRefund;
	private Long couponBuy;
	private Long couponRedeem;
	private Long couponRefund;
	private Long kpis;


	/**
	 * The total number of activities counted
	 * @return
	 */
	public Long getTotal() { return total; }
	public void setTotal( Long total ) {
		initializedFields.add( "total" );
		this.total = total;
	}

	/**
	 * The total number of KPI activities counted
	 * @return
	 */
	public Long getKpis() { return kpis; }
	public void setKpis( Long kpis ) {
		initializedFields.add( "kpis" );
		this.kpis = kpis;
	}

	/**
	 * The total number of gift activities counted
	 * @return
	 */
	public Long getGifts() { return gifts; }
	public void setGifts( Long gifts ) {
		initializedFields.add( "gifts" );
		this.gifts = gifts;
	}

	/**
	 * The total number of bounty started activities counted
	 * @return
	 */
	public Long getBountiesStarted() { return bountiesStarted; }
	public void setBountiesStarted( Long bountiesStarted ) {
		initializedFields.add( "bountiesStarted" );
		this.bountiesStarted = bountiesStarted;
	}

	/**
	 * The total number of bounty awarded activities counted
	 * @return
	 */
	public Long getBountiesAwarded() { return bountiesAwarded; }
	public void setBountiesAwarded( Long bountiesAwarded ) {
		initializedFields.add( "bountiesAwarded" );
		this.bountiesAwarded = bountiesAwarded;
	}

	/**
	 * The total number of bounty cancelled activities counted
	 * @return
	 */
	public Long getBountiesCancelled() { return bountiesCancelled; }
	public void setBountiesCancelled( Long bountiesCancelled ) {
		initializedFields.add( "bountiesCancelled" );
		this.bountiesCancelled = bountiesCancelled;
	}

	/**
	 * The total number of activities with point increments counted
	 * @return
	 */
	public Long getPointIncrement() { return pointIncrement; }
	public void setPointIncrement( Long pointIncrement ) {
		initializedFields.add( "pointIncrement" );
		this.pointIncrement = pointIncrement;
	}

	/**
	 * The total number of activities with point sets counted
	 * @return
	 */
	public Long getPointSet() { return pointSet; }
	public void setPointSet( Long pointSet ) {
		initializedFields.add( "pointSet" );
		this.pointSet = pointSet;
	}

	/**
	 * The total number of activities with point redeems counted
	 * @return
	 */
	public Long getPointRedeem() { return pointRedeem; }
	public void setPointRedeem( Long pointRedeem ) {
		initializedFields.add( "pointRedeem" );
		this.pointRedeem = pointRedeem;
	}

	/**
	 * The total number of activities with point refunds counted
	 * @return
	 */
	public Long getPointRefund() { return pointRefund; }
	public void setPointRefund( Long pointRefund ) {
		initializedFields.add( "pointRefund" );
		this.pointRefund = pointRefund;
	}

	/**
	 * The total number of activities with coupon buys counted
	 * @return
	 */
	public Long getCouponBuy() { return couponBuy; }
	public void setCouponBuy( Long couponBuy ) {
		initializedFields.add( "couponBuy" );
		this.couponBuy = couponBuy;
	}

	/**
	 * The total number of activities with coupon redeems counted
	 * @return
	 */
	public Long getCouponRedeem() { return couponRedeem; }
	public void setCouponRedeem( Long couponRedeem ) {
		initializedFields.add( "couponRedeem" );
		this.couponRedeem = couponRedeem;
	}

	/**
	 * The total number of activities with coupon refunds counted
	 * @return
	 */
	public Long getCouponRefund() { return couponRefund; }
	public void setCouponRefund( Long couponRefund ) {
		initializedFields.add( "couponRefund" );
		this.couponRefund = couponRefund;
	}

	/**
	 * The total number of activities with behaviours counted
	 * @return
	 */
	public Long getBehaviours() { return behaviours; }
	public void setBehaviours( Long behaviours ) {
		initializedFields.add( "behaviours" );
		this.behaviours = behaviours;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}

	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		builder.append( "ActivityDataPoint [total=" );
		builder.append( total );
		builder.append( ", gifts=" );
		builder.append( gifts );
		builder.append( ", behaviours=" );
		builder.append( behaviours );
		builder.append( ", bountiesStarted=" );
		builder.append( bountiesStarted );
		builder.append( ", bountiesAwarded=" );
		builder.append( bountiesAwarded );
		builder.append( ", bountiesCancelled=" );
		builder.append( bountiesCancelled );
		builder.append( ", pointIncrement=" );
		builder.append( pointIncrement );
		builder.append( ", pointSet=" );
		builder.append( pointSet );
		builder.append( ", pointRedeem=" );
		builder.append( pointRedeem );
		builder.append( ", pointRefund=" );
		builder.append( pointRefund );
		builder.append( ", couponRedeem=" );
		builder.append( couponRedeem );
		builder.append( ", couponRefund=" );
		builder.append( couponRefund );
		builder.append( ", kpis=" );
		builder.append( kpis );
		builder.append( "][super: " );
		builder.append( super.toString() );
		builder.append( "]" );
		return builder.toString();
	}
}
