/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics.model.attributes;

import java.util.List;
import java.util.Map;

import io.mambo.sdk.service.analytics.model.attributes.datapoint.IdListDataPoint;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines analytics attributes specific to a behaviour time series
 */
@ToString
@EqualsAndHashCode
public class AnalyticsBehaviourAttrs implements AnalyticsAttrs, HasInitializedData
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String reportType;
	private IdListDataPoint daily;
	private Map<String, String> nameById;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return "behaviour"; }

	/**
	 * The report type of the attributes
	 */
	public String getReportType() { return reportType; }
	public void setReportType( String reportType ) {
		initializedFields.add( "reportType" );
		this.reportType = reportType;
	}

	/**
	 * The daily data point for the attribute
	 */
	public IdListDataPoint getDaily() { return daily; }
	public void setDaily( IdListDataPoint daily ) {
		initializedFields.add( "daily" );
		this.daily = daily;
	}

	/**
	 * The names of the behaviours by ID
	 * @return
	 */
	public Map<String,String> getNameById() { return nameById; }
	public void setNameById( Map<String, String> nameById ) {
		initializedFields.add( "nameById" );
		this.nameById = nameById;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
