/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics.model;

import io.mambo.sdk.service.analytics.model.attributes.AnalyticsAttrs;
import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * This is returned when analytics data is retrieved
 */
@ToString
@EqualsAndHashCode
public class AnalyticsTimeSeriesDto implements AggregateDto, HasId
{
	private String id;
	private String timeSeriesDate;
	private AnalyticsAttrs attrs;


	/**
	 * This ID uniquely identifies this object
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * This is the date for which this time series object
	 * is storing the counters.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getTimeSeriesDate() { return timeSeriesDate; }
	public void setTimeSeriesDate( String timeSeriesDate ) { this.timeSeriesDate = timeSeriesDate; }

	/**
	 * The attributes of the analytics.
	 * @return
	 */
	public AnalyticsAttrs getAttrs() { return attrs; }
	public void setAttrs( AnalyticsAttrs attrs ) { this.attrs = attrs; }
}
