/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.analytics;

import java.util.List;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.analytics.model.AnalyticsTimeSeriesDto;
import io.mambo.sdk.service.analytics.param.AnalyticsGetListParams;
import io.mambo.sdk.service.common.AbstractService;

/**
 * The AnalyticService class handles all Analytics related requests to the Mambo
 * API.
 */
public final class AnalyticsService extends AbstractService
{
	private static final String ANALYTICS_SITE_URI = "/v1/{siteUrl}/analytics";


	public AnalyticsService( ApiRequestAdapter apiClient ) {
		super( apiClient );
	}


	/**
	 * Get the list of analytics data for the specified site.
	 *
	 * @param params
	 *            The parameters required to retrieve the analytics
	 * @return
	 */
	public List<AnalyticsTimeSeriesDto> getAnalytics( AnalyticsGetListParams params )
	{
		return getAnalytics( params, RequestOptions.create() );
	}


	/**
	 * Get the list of analytics data for the specified site.
	 *
	 * @param params
	 *            The parameters required to retrieve the analytics
	 * @param requestOptions
	 *            The options to be used with this request
	 * @return
	 */
	public List<AnalyticsTimeSeriesDto> getAnalytics(
		AnalyticsGetListParams params,
		RequestOptions requestOptions )
	{
		return apiClient().request( ApiRequest.builder()
			.apiPath( ANALYTICS_SITE_URI )
			.responseClass( AnalyticsTimeSeriesDto.class )
			.responseType( ResponseType.LIST )
			.method( HttpMethod.GET )
			.options( requestOptions )
			.params( params )
			.build() );
	}

}
