/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.activity.model.attributes;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines activity attributes specific to KPIs.
 */
@ToString
@EqualsAndHashCode
public class ActivityKPIAttrs implements ActivityAttrs, HasInitializedData
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String kpiId;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return "kpi"; }

	/**
	 * The ID of the KPI the targets of which we want to change.
	 * @return
	 */
	public String getKpiId() { return kpiId; }
	public void setKpiId( String kpiId ) {
		initializedFields.add( "kpiId" );
		this.kpiId = kpiId;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
