/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.activity.model.attributes;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.coupon.model.CouponDto;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines activity attributes specific to coupons.
 */
@ToString
@EqualsAndHashCode
public class ActivityCouponAttrs implements ActivityAttrs, HasInitializedData
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String couponId;
	private String code;
	private String action;
	private CouponDto coupon;


	/**
	 * The type of attribute
	 *
	 * @return
	 */
	@Override
	public String getType() { return "coupon"; }

	/**
	 * The ID of the coupon being redeemed / refunded in exchange for points by the user.
	 * This will be populated when querying the platform for activities.
	 * When submitting a coupon for redemption, please use the Coupon Code field.
	 * @return
	 */
	public String getCouponId() { return couponId; }
	public void setCouponId( String couponId )
	{
		initializedFields.add( "couponId" );
		this.couponId = couponId;
	}

	/**
	 * The coupon code to be used for this activity
	 */
	public String getCode() { return code; }
	public void setCode( String code ) {
		initializedFields.add( "code" );
		this.code = code;
	}

	/**
	 * The action associated to the coupon activity. The actions currently
	 * available are:<br>
	 * Buy: buys the coupon<br>
	 * Redeem: redeems the user's coupon<br>
	 * Refund: refunds the user's coupon
	 * @return
	 */
	public String getAction() { return action; }
	public void setAction( String action ) {
		initializedFields.add( "action" );
		this.action = action;
	}

	/**
	 * The coupon code to be used for this activity
	 */
	public CouponDto getCoupon() { return coupon; }
	public void setCoupon( CouponDto coupon ) {
		this.coupon = coupon;
	}


	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
