/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.activity.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.tag.model.TagDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's tags
 */
@ToString
@EqualsAndHashCode
public class UserTagsDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private List<TagDto> tags;
	private List<String> tagIds;


	/**
	 * This should contain the list of the IDs of the tags which
	 * will be given to or removed from the user when unlocking these prizes.
	 * @return
	 */
	public List<String> getTagIds() { return tagIds; }
	public void setTagIds( List<String> tagIds ) {
		initializedFields.add( "tagIds" );
		this.tagIds = tagIds;
	}


	/**
	 * This contains the list of {@link TagDto} associated to this object.
	 * @return
	 */
	public List<TagDto> getTags() { return tags; }
	public void setTags( List<TagDto> tags ) {
		initializedFields.add( "tags" );
		this.tags = tags;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
